/*
 * Decompiled with CFR 0.152.
 */
package com.dodgeman.shw.saveddata.mappers;

import com.dodgeman.shw.saveddata.mappers.CompoundMapper;
import com.dodgeman.shw.saveddata.mappers.HomeMapper;
import com.dodgeman.shw.saveddata.mappers.WaypointMapper;
import com.dodgeman.shw.saveddata.models.Home;
import com.dodgeman.shw.saveddata.models.PlayerHomeAndWaypoints;
import com.dodgeman.shw.saveddata.models.Waypoint;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class PlayerHomeAndWaypointsMapper
implements CompoundMapper<PlayerHomeAndWaypoints> {
    private static final String HOME_KEY = "home";
    private static final String WAYPOINTS_KEY = "waypoints";
    private static final String HAS_ALREADY_SET_WAYPOINT_KEY = "hasAlreadySetWaypoint";
    private static final String HAS_ALREADY_SET_HOME_IN_THE_NETHER_KEY = "hasAlreadySetHomeInTheNether";
    private static final String HAS_ALREADY_SET_HOME_IN_THE_END_KEY = "hasAlreadySetHomeInTheEnd";
    public static final String LAST_EXECUTION_OF_HOME_COMMAND_KEY = "lastExecutionOfHomeCommand";
    public static final String LAST_EXECUTION_OF_WAYPOINT_USE_COMMAND_KEY = "lastExecutionOfWaypointUseCommand";
    private static final String LAST_DELETED_WAYPOINT_KEY = "lastDeletedWaypoint";
    private static final String LAST_DELETED_WAYPOINT_AT_KEY = "lastDeletedWaypointAt";
    private static final String UNDO_INFORMATION_HAS_BEEN_SHOWN_AT_KEY = "undoInformationHasBeenShownAt";
    private static final String REMOVE_WAYPOINT_SUCCESS_MESSAGE_INDEX_KEY = "removeWaypointSuccessMessageIndex";
    private final CompoundMapper<Home> homeMapper = new HomeMapper();
    private final CompoundMapper<Waypoint> waypointMapper = new WaypointMapper();

    @Override
    public PlayerHomeAndWaypoints fromCompoundTag(CompoundTag tag) {
        Home home = this.homeMapper.fromCompoundTag(tag.m_128469_(HOME_KEY));
        CompoundTag waypointsTag = tag.m_128469_(WAYPOINTS_KEY);
        List<Waypoint> waypoints = waypointsTag.m_128431_().stream().map(waypointName -> this.waypointMapper.fromCompoundTag(waypointsTag.m_128469_(waypointName))).toList();
        boolean hasAlreadySetWaypoint = tag.m_128471_(HAS_ALREADY_SET_WAYPOINT_KEY);
        boolean hasAlreadySetHomeInTheNether = tag.m_128471_(HAS_ALREADY_SET_HOME_IN_THE_NETHER_KEY);
        boolean hasAlreadySetHomeInTheEnd = tag.m_128471_(HAS_ALREADY_SET_HOME_IN_THE_END_KEY);
        long lastExecutionOfHomeCommand = tag.m_128454_(LAST_EXECUTION_OF_HOME_COMMAND_KEY);
        long lastExecutionOfWaypointUseCommand = tag.m_128454_(LAST_EXECUTION_OF_WAYPOINT_USE_COMMAND_KEY);
        Waypoint lastDeletedWaypoint = this.waypointMapper.fromCompoundTag(tag.m_128469_(LAST_DELETED_WAYPOINT_KEY));
        long lastDeletedWaypointAt = tag.m_128454_(LAST_DELETED_WAYPOINT_AT_KEY);
        long undoInformationHasBeenShownAt = tag.m_128454_(UNDO_INFORMATION_HAS_BEEN_SHOWN_AT_KEY);
        int removeWaypointSuccessMessageIndex = tag.m_128451_(REMOVE_WAYPOINT_SUCCESS_MESSAGE_INDEX_KEY);
        return new PlayerHomeAndWaypoints(home, waypoints, hasAlreadySetWaypoint, hasAlreadySetHomeInTheNether, hasAlreadySetHomeInTheEnd, lastExecutionOfHomeCommand, lastExecutionOfWaypointUseCommand, lastDeletedWaypoint, lastDeletedWaypointAt, undoInformationHasBeenShownAt, removeWaypointSuccessMessageIndex);
    }

    @Override
    public CompoundTag toCompoundTag(PlayerHomeAndWaypoints playerHomeAndWaypoints) {
        CompoundTag tag = new CompoundTag();
        if (playerHomeAndWaypoints == null) {
            return tag;
        }
        CompoundTag waypointsTag = new CompoundTag();
        playerHomeAndWaypoints.getWaypoints().forEach((waypointName, waypoint) -> waypointsTag.m_128365_((String)waypointName.value(), (Tag)this.waypointMapper.toCompoundTag((Waypoint)waypoint)));
        tag.m_128365_(HOME_KEY, (Tag)this.homeMapper.toCompoundTag(playerHomeAndWaypoints.getHome()));
        tag.m_128365_(WAYPOINTS_KEY, (Tag)waypointsTag);
        tag.m_128379_(HAS_ALREADY_SET_WAYPOINT_KEY, playerHomeAndWaypoints.hasAlreadySetWaypoint());
        tag.m_128379_(HAS_ALREADY_SET_HOME_IN_THE_NETHER_KEY, playerHomeAndWaypoints.hasAlreadySetHomeInTheNether());
        tag.m_128379_(HAS_ALREADY_SET_HOME_IN_THE_END_KEY, playerHomeAndWaypoints.hasAlreadySetHomeInTheEnd());
        tag.m_128356_(LAST_EXECUTION_OF_HOME_COMMAND_KEY, playerHomeAndWaypoints.getLastExecutionOfHomeCommand());
        tag.m_128356_(LAST_EXECUTION_OF_WAYPOINT_USE_COMMAND_KEY, playerHomeAndWaypoints.getLastExecutionOfWaypointUseCommand());
        tag.m_128356_(LAST_DELETED_WAYPOINT_AT_KEY, playerHomeAndWaypoints.getLastDeletedWaypointAt());
        tag.m_128365_(LAST_DELETED_WAYPOINT_KEY, (Tag)this.waypointMapper.toCompoundTag(playerHomeAndWaypoints.getLastDeletedWaypoint()));
        tag.m_128356_(UNDO_INFORMATION_HAS_BEEN_SHOWN_AT_KEY, playerHomeAndWaypoints.getUndoInformationHasBeenShownAt());
        tag.m_128356_(REMOVE_WAYPOINT_SUCCESS_MESSAGE_INDEX_KEY, (long)playerHomeAndWaypoints.getRemoveWaypointSuccessMessageIndex());
        return tag;
    }
}

